#include <stdio.h>
#include <winsock.h>
#include "Pagalba.h"

/****************************************************************/
/*	Funkcija skirta gauti nurodyto ilgio simboliu eilutes       */
/****************************************************************/
void PriimtiStr(SOCKET s, int ilgis, char* rez){
                       //s - Soketas is kurio laukiama simboliu eilutes
                       //ilgis - laukiamos simboliu eilutes ilgis
                       //rez - adresas vietos, kur bus irasyta gautoji eilute
	int perskaityta=0;                 //kiek simboliu jau perskaityta
	int gauta;
	char buf[MAX_DYDIS];               //eilutes priemimo buferis
	while (perskaityta < ilgis)        //dirbame tol, kol gauname tiek baitu, kiek reikia
	{
		gauta= recv(s, &buf[perskaityta], ilgis-perskaityta, 0);	//gauta - kiek baitu gavo
		if (gauta < 0)
		{
			printf("Ivyko klaida laukiant komandos: %i\n", WSAGetLastError());
			return;
		}
        else
		{
			perskaityta += gauta;
		}
	}
	memcpy(&rez[0], &buf[0], ilgis);    //nukopijuojame gauta eilute is buferio i rezultatui skirta vieta
}

/****************************************************************/
/*	Funkcija skirta siusti nurodyto ilgio simboliu eilutes      */
/****************************************************************/
                       //s - Soketas kuriam sunciama simboliu eilute
                       //str - adresas vietos, kur irasyta siunciama eilute
                       //ilgis - siunciamos simboliu eilutes ilgis
void SiustiStr(SOCKET s, char* str, int ilgis){
	if (send(s, str, ilgis, 0) < 0){
		printf("Ivyko klaida siunciant komanda: %i\n", WSAGetLastError());
		return;
	}
}

/****************************************************************/
/*	Funkcija skirta gauti naturalu skaiciu                      */
/****************************************************************/
int PriimtiSk(SOCKET s){
                       //s - Soketas is kurio laukiama skaiciaus
                       //funkcijos rezultatas - gautasis skaicius
    int sk;
    char rez[sizeof(int)+1];
    PriimtiStr(s, sizeof(int)+1, &rez[0]);        //gauname integeri kaip stringa
    memcpy(&sk, &rez[0], sizeof(int));        //nukopijuojame stringa i integerio vieta
    sk= ntohl(sk);                            //reikalinga, kad isvengtume problemu su baitu tvarka
    return sk;
}

/****************************************************************/
/*	Funkcija skirta siusti naturalu skaiciu                     */
/****************************************************************/
void SiustiSk(SOCKET s, int sk){
                       //s - Soketas kuriam sunciamas skaicius
                       //sk - siunciamas skaicius
	sk=htonl(sk);                                //reikalinga, kad isvengtume problemu su baitu tvarka
	char kur[sizeof(int)+1];
	memcpy(&kur[0], &sk, sizeof(int));	         //nukopijuoju integeri i stringo vieta
	kur[sizeof(int)]='\0';
    SiustiStr(s, &kur[0], sizeof(int)+1);        //siunciame integeri kaip stringa
}


